/** @file   youko.h
 * @brief   Declaration of Youko - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_YOUKO_H
#define H_WWW_YOUKO_H

#include "npccharacter.h"


namespace WeWantWar {

/** @class  Youko
 * @brief   Youko is the character that must be saved in later levels.
 * @author  Tomi Lamminsaari
 *
 */
class Youko : public NpcCharacter
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	Youko();


	/** Destructor
   */
	virtual ~Youko();

private:

	/** Copy constructor.
   * @param     rO                Reference to another Youko
   */
  Youko( const Youko& rO );

	/** Assignment operator
   * @param     rO                Reference to another Youko
   * @return    Reference to us.
   */
  Youko& operator = ( const Youko& rO );

public:


  ///
  /// Methods
  /// =======

  /** Updates the Youko
   */
  virtual void update();
  
  /** Handles the messages
   * @param     rMessage          The message sent to us.
   */
  virtual void messagePort( const ObjectMessage& rMessage );

  /** Sets the weapon.
   * @param     w                 New weapon
   */
  virtual void setWeapon( Weapon w );

  /** Reimplemented kill-method so that we can apply the cheat code. If the
   * Settings::cheatYouko - flag is on, this method does not kill the Youko.
   */
  virtual void kill();

  ///
  /// Getter methods
  /// ==============

  

protected:

  ///
  /// Members
  /// =======

  /** Returns the type of this object.
   * @return    ObjectID::TYPE_YOUKO
   */
  virtual ObjectID::Type objectType() const;


private:

  ///
  /// Private members
  /// ===============

  /** Movement vector */
  eng2d::Vec2D  m_movementVec;
};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: youko.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:23+02  lamminsa
 * Initial revision
 *
 */
 
